package im_user_relationship

import (
	"context"

	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"im-microservice/sevice/im_user"

	"im-microservice/helper"
	"im-microservice/pb"
	vs "im-microservice/validator_struct"
)

type UserRelationshipService struct {
	pb.UnimplementedUserRelationshipServiceServer
}

func (us *UserRelationshipService) Add(ctx context.Context,
	in *pb.UserRelationshipAddRequest) (reply *pb.UserRelationshipAddReply, err error) {

	m := map[string]interface{}{
		"accid":  in.GetAccid(),
		"faccid": in.GetFaccid(),
		"type":   in.GetType(),
		"msg":    in.GetMsg(),
	}
	request := vs.NewUserRelationshipAdd(m)
	if err = helper.Valiator(request); err != nil {
		return
	}
	if ok := IsUserRelationship(request.Accid, request.Faccid); ok {
		err = status.Error(codes.AlreadyExists, "已经添加过该好友")
		return
	}
	//添加好友
	if err = AddUserRelationship(request); err != nil {
		return
	}
	// 更改用户版本信息
	u_map := make(map[string]interface{})
	u_map["edition"] = helper.GetNowTime()
	_, _ = im_user.UpdateImUser(request.Accid, u_map)

	reply = &pb.UserRelationshipAddReply{}
	return
}

func (us *UserRelationshipService) Delete(ctx context.Context,
	in *pb.UserRelationshipDelRequest) (reply *pb.UserRelationshipAddReply, err error) {

	m := map[string]interface{}{
		"accid":  in.GetAccid(),
		"faccid": in.GetFaccid(),
	}
	request := vs.NewUserRelationshipDel(m)
	if err = helper.Valiator(request); err != nil {
		return
	}
	// 删除好友
	if err = DBDelete(request); err != nil {
		return
	}
	// 更改用户版本信息
	u_map := make(map[string]interface{})
	u_map["edition"] = helper.GetNowTime()
	_, _ = im_user.UpdateImUser(request.Accid, u_map)

	reply = &pb.UserRelationshipAddReply{}
	return
}

func (us *UserRelationshipService) All(ctx context.Context,
	in *pb.UserRelationshipListRequest) (reply *pb.UserRelationshipListReply, err error) {

	m := map[string]interface{}{
		"accid":      in.GetAccid(),
		"updatetime": in.GetUpdatetime(),
	}
	request := vs.NewUserRelationshipAll(m)
	if err = helper.Valiator(request); err != nil {
		return
	}

	results, err := DBAll(request)
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.UserRelationshipListReply{}
	for _, v := range results {
		reply.List = append(reply.List, &pb.UserRelationshipInfo{
			Faccid:     v.Faccid,
			Updatetime: v.Updatetime,
		})
	}
	return
}

func (us *UserRelationshipService) SetSpecialRelation(ctx context.Context,
	in *pb.SetSpecialRelationReq) (reply *pb.UserRelationshipAddReply, err error) {

	m := map[string]interface{}{
		"accid":         in.GetAccid(),
		"faccid":        in.GetTargetAcc(),
		"relation_type": in.GetRelationType(),
		"value":         in.GetValue(),
	}
	request := vs.NewSetSpecialRelation(m)
	if err = helper.Valiator(request); err != nil {
		return
	}
	if err = SetSpecialRelationDb(request); err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.UserRelationshipAddReply{}
	return
}

func (us *UserRelationshipService) ListBlackAndMuteList(ctx context.Context,
	in *pb.ListBlackAndMuteListReq) (reply *pb.ListBlackAndMuteListReply, err error) {

	m := map[string]interface{}{
		"accid": in.GetAccid(),
	}
	request := vs.NewListBlackAndMuteList(m)
	if err = helper.Valiator(request); err != nil {
		return
	}

	blacklist, mutelist, err := ListBlackAndMuteListDB(request)
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.ListBlackAndMuteListReply{}

	if len(blacklist) > 0 {
		for _, v := range blacklist {
			reply.Blacklist = append(reply.Blacklist,
				&pb.UserRelationshipInfo{Updatetime: v.Updatetime, Faccid: v.Faccid})
		}
	}
	if len(mutelist) > 0 {
		for _, v := range mutelist {
			reply.Mutelist = append(reply.Mutelist,
				&pb.UserRelationshipInfo{Updatetime: v.Updatetime, Faccid: v.Faccid})
		}
	}
	return
}
