package validator_struct

import "im-microservice/pb"

// 添加配置的参数检测
type ConfigureAddStruct struct {
	CompanyUserId   int64  `validate:"required,numeric"`
	MultideviceType int64  `validate:"required,numeric"`
	MsgHookUrl      string `validate:"required"`
}

func NewConfigureAddStruct(inter interface{}) *ConfigureAddStruct {
	config := &ConfigureAddStruct{}
	switch inter.(type) {
	case *pb.ConfigureRequest:
		var c = inter.(*pb.ConfigureRequest)
		config.CompanyUserId = c.Public.GetCompanyUserId()
		config.MultideviceType = c.Public.GetMultideviceType()
		config.MsgHookUrl = c.Public.GetMsgHookUrl()
	case map[string]interface{}:
		var c = inter.(map[string]interface{})
		if cui, ok := c["company_user_id"].(int64); ok {
			config.CompanyUserId = cui
		}
		if mt, ok := c["multidevice_type"].(int64); ok {
			config.MultideviceType = mt
		}
		if mhu, ok := c["msg_hook_url"].(string); ok {
			config.MsgHookUrl = mhu
		}
	}
	return config
}

// 修改配置
type ConfigureUpdateStruct struct {
	CompanyUserId   int64 `validate:"required,numeric"`
	MultideviceType int64
	MsgHookUrl      string
}

func NewConfigureUpdateStruct(in interface{}) *ConfigureUpdateStruct {
	var config_update = &ConfigureUpdateStruct{}
	switch in.(type) {
	case *pb.UpdateRequest:
		var v = in.(*pb.ConfigureRequest)
		config_update.CompanyUserId = v.Public.GetCompanyUserId()
		config_update.MultideviceType = v.Public.GetMultideviceType()
		config_update.MsgHookUrl = v.Public.GetMsgHookUrl()
	case map[string]interface{}:
		var c = in.(map[string]interface{})
		if cui, ok := c["company_user_id"].(int64); ok {
			config_update.CompanyUserId = cui
		}
		if mt, ok := c["multidevice_type"].(int64); ok {
			config_update.MultideviceType = mt
		}
		if mhu, ok := c["msg_hook_url"].(string); ok {
			config_update.MsgHookUrl = mhu
		}
	}
	return config_update
}

// 删除配置
type ConfigureDelStruct struct {
	CompanyUserId int64 `validate:"required,numeric"`
}

func NewConfigureDelStruct(inter interface{}) *ConfigureDelStruct {
	room := &ConfigureDelStruct{}
	switch inter.(type) {
	case *pb.ConfigureDelRequest:
		var c = inter.(*pb.ConfigureDelRequest)
		room.CompanyUserId = c.GetCompanyUserId()
	case map[string]interface{}:
		var c = inter.(map[string]interface{})
		if v, ok := c["company_user_id"].(int64); ok {
			room.CompanyUserId = v
		}
	}
	return room

}

// 创建聊天室

type ChatRoomAddStruct struct {
	Creator      string `validate:"required"`
	Name         string `validate:"required"`
	Announcement string `validate:"required"`
}

func NewAddChatRoom(in *pb.ChatRoomAddRequest) *ChatRoomAddStruct {
	return &ChatRoomAddStruct{
		Creator:      in.GetCreator(),
		Name:         in.GetName(),
		Announcement: in.GetAnnouncement(),
	}
}

// 修改聊天室

type ChatRoomUpdate struct {
	RoomId       int64 `validate:"required"`
	Name         string
	Announcement string
	Status       int64
}

func NewChatRoomUpdate(in *pb.ChatRoomUpdateRequest) *ChatRoomUpdate {
	return &ChatRoomUpdate{
		RoomId:       in.GetRoomId(),
		Name:         in.GetName(),
		Announcement: in.GetAnnouncement(),
		Status:       int64(in.GetStatus()),
	}
}

// 删除聊天室

type ChatRoomDel struct {
	RoomId int64 `validate:"required"`
}

func NewChatRoomDel(in *pb.ChatRoomDelRequest) *ChatRoomDel {
	return &ChatRoomDel{RoomId: in.GetRoomId()}
}

// 获取单个聊天室
type ChatRoomInfo struct {
	RoomId       int64 `validate:"required"`
	Creator      string
	Name         string
	Announcement string
	Status       int64
	Ext          string
	Createtime   string
	Updatetime   string
}

func NewChatRoomInfo(inter interface{}) *ChatRoomInfo {
	room := &ChatRoomInfo{}
	switch inter.(type) {
	case *pb.ChatRoomInfoRequest:
		var c = inter.(*pb.ChatRoomInfoRequest)
		room.RoomId = c.RoomId
	case map[string]interface{}:
		var c = inter.(map[string]interface{})
		if v, ok := c["room_id"].(int64); ok {
			room.RoomId = v
		}
	}
	return room
}

//添加好友
type UserRelationshipAdd struct {
	Accid  string `validate:"required"`
	Faccid string `validate:"required"`
	Type   int64  `validate:"required"`
	Msg    string
}

func NewUserRelationshipAdd(in map[string]interface{}) *UserRelationshipAdd {
	return &UserRelationshipAdd{
		Accid:  in["accid"].(string),
		Faccid: in["faccid"].(string),
		Type:   in["type"].(int64),
		Msg:    in["msg"].(string),
	}
}

// 删除好友
type UserRelationshipDel struct {
	Accid  string `validate:"required"`
	Faccid string `validate:"required"`
}

func NewUserRelationshipDel(in map[string]interface{}) *UserRelationshipDel {
	return &UserRelationshipDel{
		Accid:  in["accid"].(string),
		Faccid: in["faccid"].(string),
	}
}

// 获取好友列表

type UserRelationshipAll struct {
	Accid      string `validate:"required"`
	Updatetime string `validate:"required"`
}

func NewUserRelationshipAll(in map[string]interface{}) *UserRelationshipAll {
	return &UserRelationshipAll{
		Accid:      in["accid"].(string),
		Updatetime: in["updatetime"].(string),
	}
}

// 设置用户黑名单/禁音

type SetSpecialRelation struct {
	Accid        string `validate:"required"`
	TargetAcc    string `validate:"required"`
	RelationType int64  `validate:"required,numeric,min=1"`
	Value        int64  `validate:"required,numeric,min=1"`
}

func NewSetSpecialRelation(in map[string]interface{}) *SetSpecialRelation {
	return &SetSpecialRelation{
		Accid:        in["accid"].(string),
		TargetAcc:    in["faccid"].(string),
		RelationType: in["relation_type"].(int64),
		Value:        in["value"].(int64),
	}
}

// 获取用户列表
type ListBlackAndMuteList struct {
	Accid string `validate:"required"`
}

func NewListBlackAndMuteList(in map[string]interface{}) *ListBlackAndMuteList {
	return &ListBlackAndMuteList{Accid: in["accid"].(string)}
}
