package im_user_relationship

import (
	"errors"
	"im-microservice/pb"

	"github.com/astaxie/beego/orm"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"im-microservice/db"
	"im-microservice/helper"
)

var (
	db_tabel            = "im_user_relationship"
	db_field_accid      = "accid"
	db_field_faccid     = "faccid"
	db_field_type       = "type"
	db_field_msg        = "msg"
	db_field_blacklist  = "blacklist"
	db_field_mute       = "mute"
	db_field_serverex   = "serverex"
	db_field_updatetime = "updatetime"
	db_field_createtime = "createtime"
	open                = 2
	close               = 1
)

// 是否是好友
func IsUserRelationship(accid, faccid string) bool {
	return db.MysqlClient.QueryTable(db_tabel).Filter(db_field_accid, accid).
		Filter(db_field_faccid, faccid).Exist()
}

//是否是对方黑名单
func IsBlack(accid, faccid string) bool {
	 return db.MysqlClient.QueryTable(db_tabel).Filter(db_field_accid, faccid).
		Filter(db_field_faccid, accid).Filter(db_field_blacklist, close).Exist()

}

func AddUserRelationship(in *pb.UserRelationshipAddRequest) error {
	var (
		us db.ImUserRelationship
		ts db.ImUserRelationship
		)

	// 发起者
	now := helper.GetNowTime()
	us.Accid = in.Accid
	us.Faccid = in.Faccid
	us.Msg = in.Msg
	us.Type = int(in.Type)
	us.Updatetime = now
	us.Blacklist = open
	us.Mute = open
	us.Createtime = now
	_, err := db.MysqlClient.Insert(&us)

	if ok := IsUserRelationship(in.Faccid, in.Accid); !ok {
		// 被添加者
		ts.Accid = in.Faccid
		ts.Faccid = in.Accid
		ts.Msg = in.Msg
		ts.Type = int(in.Type)
		ts.Updatetime = now
		ts.Blacklist = open
		ts.Mute = open
		ts.Createtime = now
		_, err1 := db.MysqlClient.Insert(&ts)
		if err1 != nil {
			return status.Error(codes.Internal, err.Error())
		}
	}


	if err != nil {
		err = status.Error(codes.Internal, err.Error())
	}
	return err
}

func DBDelete(in *pb.UserRelationshipDelRequest) error {
	_, err := db.MysqlClient.QueryTable(db_tabel).Filter(db_field_accid, in.Accid).
		Filter(db_field_faccid, in.Faccid).Delete()
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
	}
	return err
}

func DBAll(in *pb.UserRelationshipListRequest) ([]db.ImUserRelationship, error) {

	var friends []db.ImUserRelationship
	num, err := db.MysqlClient.QueryTable(db_tabel).Filter(db_field_accid, in.Accid).
		Filter(db_field_blacklist, open).Filter(db_field_updatetime+"__gte", in.Updatetime).
		All(&friends, db_field_faccid, db_field_updatetime)

	if err != nil {
		return nil, err
	}
	if num == 0 {
		return nil, errors.New("好友列表为空")
	}
	return friends, nil
}

func SetSpecialRelationDb(in *pb.SetSpecialRelationReq) error {

	if ok := IsUserRelationship(in.Accid, in.TargetAcc); !ok {
		return errors.New("被操作用户不是该用户好友")
	}
	orm_params := make(orm.Params)
	// 加入黑名单
	if in.RelationType == 1 {
		if in.Value == 1 {
			//黑名单
			orm_params["blacklist"] = close
		} else {
			orm_params["blacklist"] = open
		}
	} else {
		if in.Value == 1 {
			//禁音
			orm_params["mute"] = close
		} else {
			orm_params["mute"] = open
		}
	}

	if len(orm_params) == 0 {
		return nil
	}

	_, err := db.MysqlClient.QueryTable(db_tabel).Filter(db_field_accid, in.Accid).
		Filter(db_field_faccid, in.TargetAcc).Update(orm_params)
	return err
}

func ListBlackAndMuteListDB(in *pb.ListBlackAndMuteListReq) (blacklist []db.ImUserRelationship,
	mutelist []db.ImUserRelationship, err error) {

	query_db := db.MysqlClient.QueryTable(db_tabel).Filter(db_field_accid, in.Accid)
	_, err = query_db.Filter(db_field_blacklist, close).All(&blacklist)
	if err != nil {
		return
	}
	_, err = query_db.Filter(db_field_mute, close).All(&mutelist)
	return
}
