package im_friend_request

import (
	"context"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"im-microservice/pb"
	"im-microservice/sevice/im_user"
	"im-microservice/sevice/im_user_relationship"
)

type ImFriendService struct {
	pb.UnimplementedImFriendServiceServer
}

func (fs *ImFriendService) All (ctx context.Context, in *pb.ImFriendListReq) (reply *pb.ImFriendListReply, err error) {
	// 添加用户是否存在
	if _,err = im_user.GetImUserByAccid(in.Accid); err != nil {
		err = status.Error(codes.NotFound, "用户不存在")
		return
	}
	results, err := All(in.Accid)
	if err != nil {
		return
	}
	reply = &pb.ImFriendListReply{}
	if len(results) > 0 {
		for _, v := range results {
			reply.List = append(reply.List, &pb.ImFriendListOne{
				Id:         int64(v.Id),
				Accid:      v.Accid,
				Faccid:     v.Faccid,
				Createtime: v.Createtime,
			})
		}
	}
	return
}

func (fs *ImFriendService) Add (ctx context.Context,in *pb.ImFriendAddReq) (reply *pb.ImFriendEmptyReply, err error) {
	// 添加用户是否存在
	if _,err = im_user.GetImUserByAccid(in.Accid); err != nil {
		err = status.Error(codes.NotFound, "用户不存在")
		return
	}
	// 被添加用户存在
	if _, err = im_user.GetImUserByAccid(in.Faccid); err != nil {
		err = status.Error(codes.NotFound, "被添加用户不存在")
		return
	}
	//是否已经添加过好友
	if ok := im_user_relationship.IsUserRelationship(in.Accid, in.Faccid); ok {
		err = status.Error(codes.AlreadyExists, "已经添加过该好友")
		return
	}
	//对方用户黑名单不能添加
	if ok :=im_user_relationship.IsBlack(in.Accid, in.Faccid); ok {
		err = status.Error(codes.AlreadyExists, "已经添加过该好友")
		return
	}
	// 已经提过添加好友申请
	if ok := FindExits(in.Accid, in.Faccid); ok {
		err = status.Error(codes.AlreadyExists, "已经提交过申请")
		return
	}
	if err = AddRecord(in); err != nil {
		return
	}
	reply = &pb.ImFriendEmptyReply{}
	return
}

func (fs *ImFriendService) Update(ctx context.Context, in *pb.ImFriendUpdateReq) (reply *pb.ImFriendEmptyReply, err error) {
	if err = Update(in);  err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.ImFriendEmptyReply{}
	return
}
