package im_configure

import (
	"errors"

	"im-microservice/db"
	"im-microservice/validator_struct"

	"github.com/astaxie/beego/orm"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

const (
	b_table_name = "im_base"
	b_user_id    = "company_user_id"
	b_type       = "multidevice_type"
	b_url        = "msg_hook_url"
)

func GetImBaseByUserId(user_id int64) (db.ImBase, error) {
	var im_base db.ImBase
	err := db.MysqlClient.QueryTable(b_table_name).
		Filter(b_user_id, user_id).One(&im_base)
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
	}
	return im_base, err
}

func AddImBase(im *validator_struct.ConfigureAddStruct) error {
	configure := new(db.ImBase)
	configure.CompanyUserId = im.CompanyUserId
	configure.MsgHookUrl = im.MsgHookUrl
	configure.MultideviceType = im.MultideviceType
	_, err := db.MysqlClient.Insert(configure)
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
	}
	return nil
}

func DelConfigure(user_id int64) (err error) {
	configure := new(db.ImBase)
	configure.CompanyUserId = user_id
	_, err = db.MysqlClient.Delete(configure)
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	return
}

func GetConfigureAll() ([]*db.ImBase, error) {
	var configurs []*db.ImBase
	num, err := db.MysqlClient.QueryTable(b_table_name).All(&configurs)
	if num == 0 {
		return configurs, nil
	}
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
	}
	return configurs, err
}

func UpdateConfiguer(im *validator_struct.ConfigureUpdateStruct) error {
	orm_params := make(orm.Params)
	if im.MsgHookUrl != "" {
		orm_params[b_url] = im.MsgHookUrl
	}
	if im.MultideviceType != 0 {
		orm_params[b_type] = im.MultideviceType
	}
	if len(orm_params) == 0 {
		return errors.New("没有数据更改")
	}
	_, err := db.MysqlClient.QueryTable(b_table_name).
		Filter(b_user_id, im.CompanyUserId).Update(orm_params)
	return err
}
