package im_chat_room

import (
	"context"

	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
	"im-microservice/db"
	"im-microservice/pb"
)

type ImChatRoomService struct {
	pb.UnimplementedChatRoomServiceServer
}

func (cr *ImChatRoomService) Add(ctx context.Context,
	in *pb.ChatRoomAddRequest) (reply *pb.ChatRoomAddReply, err error) {

	room_id, err := AddChatRoom(in)
	if err != nil {
		return
	}
	reply = &pb.ChatRoomAddReply{}
	reply.Id = room_id
	return
}

func (cr *ImChatRoomService) Update(ctx context.Context,
	in *pb.ChatRoomUpdateRequest) (reply *pb.ChatRoomUpdateReply, err error) {

	if err = UpdateChatRoom(in); err != nil {
		return
	}
	reply = &pb.ChatRoomUpdateReply{}
	return
}

func (cr *ImChatRoomService) Delete(ctx context.Context,
	in *pb.ChatRoomDelRequest) (reply *pb.ChatRoomDelReply, err error) {

	if err = DeleteChatRoom(in.RoomId); err != nil {
		return
	}
	reply = &pb.ChatRoomDelReply{}
	return
}

func (cr *ImChatRoomService) Info(ctx context.Context,
	in *pb.ChatRoomInfoRequest) (reply *pb.ChatRoomInfoReply, err error) {

	db_chat_room, err := ChatRoomInfo(in)
	if err != nil {
		return
	}
	reply = getchatroom(db_chat_room)
	return
}
func getchatroom(room db.ImChatRoom) *pb.ChatRoomInfoReply {

	return &pb.ChatRoomInfoReply{
		RoomId:       int64(room.Id),
		Creator:      room.Creator,
		Name:         room.Name,
		Announcement: room.Announcement,
		Status:       int64(room.Status),
		Ext:          room.Ext,
		Createtime:   room.Createtime,
		Updatetime:   room.Updatetime,
	}
}

func (cr *ImChatRoomService) All(ctx context.Context,
	in *pb.ChatRoomAllRequest) (reply *pb.GetChatRoomsReply, err error) {
	results, err := GetChatRooms(in)
	if err != nil {
		err = status.Error(codes.Internal, err.Error())
		return
	}
	reply = &pb.GetChatRoomsReply{Paginate: &pb.Page{}}
	if len(results) == 0 {
		return
	}
	db_rooms := results["list"].([]db.ImChatRoom)
	for _, v := range db_rooms {
		reply.List = append(reply.List, getchatroom(v))
	}

	reply.Paginate.PageSize = int64(results["page_size"].(int))
	reply.Paginate.PagetNo = results["page"].(int64)
	reply.Paginate.TotalCount = results["total_count"].(int64)
	reply.Paginate.TotalPage = results["total_page"].(int64)
	return
}
