package initialization

import (
	"time"

	"im-microservice/middleware"
	"im-microservice/pb"
	"im-microservice/sevice/health"
	"im-microservice/sevice/im_chat_room"
	"im-microservice/sevice/im_friend_request"
	"im-microservice/sevice/im_chat_room_user"
	ic "im-microservice/sevice/im_configure"
	"im-microservice/sevice/im_user"
	iur "im-microservice/sevice/im_user_relationship"

	"github.com/grpc-ecosystem/go-grpc-middleware"
	grpc_zap "github.com/grpc-ecosystem/go-grpc-middleware/logging/zap"
	grpc_recovery "github.com/grpc-ecosystem/go-grpc-middleware/recovery"
	grpc_validator "github.com/grpc-ecosystem/go-grpc-middleware/validator"

	"google.golang.org/grpc"
	"google.golang.org/grpc/keepalive"
	"google.golang.org/grpc/reflection"
)

var (
	RpcServer *grpc.Server
	kaep      = keepalive.EnforcementPolicy{
		MinTime:             5 * time.Second,
		PermitWithoutStream: true,
	}

	kasp = keepalive.ServerParameters{
		MaxConnectionIdle:     15 * time.Second,
		MaxConnectionAge:      30 * time.Second,
		MaxConnectionAgeGrace: 5 * time.Second,
		Time:                  5 * time.Second,
		Timeout:               1 * time.Second,
	}
)

func init() {

	rpc_server := grpc.NewServer(grpc.KeepaliveEnforcementPolicy(kaep), grpc.KeepaliveParams(kasp),
		grpc.UnaryInterceptor(grpc_middleware.ChainUnaryServer(
			middleware.Interceptor,
			grpc_validator.UnaryServerInterceptor(),
			middleware.Interceptor,
			//middleware.Auth,
			grpc_recovery.UnaryServerInterceptor(middleware.RecoveryInterceptor()),
			grpc_zap.UnaryServerInterceptor(middleware.ZapInterceptor()),
		)))
	srv := health.NewServer()
	pb.RegisterHealthServer(rpc_server, srv)
	pb.RegisterConfigureSeviceServer(rpc_server, &ic.ConfigureSevice{})
	pb.RegisterChatRoomServiceServer(rpc_server, &im_chat_room.ImChatRoomService{})
	pb.RegisterImUserServer(rpc_server, &im_user.ImUserServer{})
	pb.RegisterUserRelationshipServiceServer(rpc_server, &iur.UserRelationshipService{})
	pb.RegisterImFriendServiceServer(rpc_server, &im_friend_request.ImFriendService{})
	pb.RegisterChatRoomUserServer(rpc_server, &im_chat_room_user.ChatRoomUserServer{})

	reflection.Register(rpc_server)
	RpcServer = rpc_server

}
